<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PADRINO License Server - Login</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            position: relative;
            overflow: hidden;
        }
        
        /* Animated background */
        body::before {
            content: '';
            position: absolute;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 1px, transparent 1px);
            background-size: 50px 50px;
            animation: move 20s linear infinite;
            top: -50%;
            left: -50%;
        }
        
        @keyframes move {
            0% { transform: translate(0, 0); }
            100% { transform: translate(50px, 50px); }
        }
        
        .login-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            padding: 50px 40px;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            width: 100%;
            max-width: 420px;
            position: relative;
            z-index: 1;
            border: 1px solid rgba(255,255,255,0.2);
        }
        
        .logo {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .logo-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 20px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-size: 40px;
            margin-bottom: 15px;
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
        }
        
        .logo h1 {
            color: #1a1a1a;
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 5px;
            letter-spacing: -0.5px;
        }
        
        .logo p {
            color: #666;
            font-size: 14px;
            font-weight: 500;
        }
        
        .form-group {
            margin-bottom: 24px;
            position: relative;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #1a1a1a;
            font-size: 14px;
        }
        
        .form-group input {
            width: 100%;
            padding: 14px 16px;
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            font-size: 15px;
            transition: all 0.3s ease;
            background: #fff;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
        }
        
        .btn {
            width: 100%;
            padding: 16px;
            border: none;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            margin-top: 8px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
        }
        
        .btn:active {
            transform: translateY(0);
        }
        
        .error {
            background: linear-gradient(135deg, #fee 0%, #fdd 100%);
            color: #dc2626;
            padding: 14px 16px;
            border-radius: 12px;
            margin-bottom: 20px;
            display: none;
            font-size: 14px;
            border: 1px solid #fecaca;
        }
        
        .error.show {
            display: block;
            animation: shake 0.5s;
        }
        
        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            25% { transform: translateX(-10px); }
            75% { transform: translateX(10px); }
        }
        
        .info-card {
            background: linear-gradient(135deg, #e0e7ff 0%, #ddd6fe 100%);
            padding: 16px;
            border-radius: 12px;
            margin-top: 24px;
            font-size: 13px;
            border: 1px solid #c7d2fe;
        }
        
        .info-card strong {
            color: #4c1d95;
            display: block;
            margin-bottom: 8px;
        }
        
        .info-card .credentials {
            color: #5b21b6;
            font-family: 'Courier New', monospace;
            margin: 4px 0;
        }
        
        .info-card .warning {
            color: #dc2626;
            font-size: 11px;
            margin-top: 8px;
            font-weight: 600;
        }
        
        .divider {
            text-align: center;
            margin: 24px 0;
            position: relative;
            color: #9ca3af;
            font-size: 13px;
        }
        
        .divider::before,
        .divider::after {
            content: '';
            position: absolute;
            top: 50%;
            width: 45%;
            height: 1px;
            background: #e5e7eb;
        }
        
        .divider::before {
            left: 0;
        }
        
        .divider::after {
            right: 0;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo">
            <div class="logo-icon">🔐</div>
            <h1>PADRINO License</h1>
            <p>Admin Control Panel</p>
        </div>
        
        <div class="error" id="errorMessage"></div>
        
        <form id="loginForm">
            <div class="form-group">
                <label>Username</label>
                <input type="text" id="username" required autofocus placeholder="Enter your username">
            </div>
            
            <div class="form-group">
                <label>Password</label>
                <input type="password" id="password" required placeholder="Enter your password">
            </div>
            
            <button type="submit" class="btn">Sign In</button>
        </form>
        
        <div class="divider">Default Credentials</div>
        
        <div class="info-card">
            <strong>🔑 Default Login</strong>
            <div class="credentials">Username: <strong>admin</strong></div>
            <div class="credentials">Password: <strong>admin123</strong></div>
            <div class="warning">⚠️ Change these credentials after first login!</div>
        </div>
    </div>
    
    <script>
        const baseUrl = window.location.pathname.replace(/\/[^\/]*$/, '');
        
        document.getElementById('loginForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            const username = document.getElementById('username').value;
            const password = document.getElementById('password').value;
            const errorDiv = document.getElementById('errorMessage');
            const btn = document.querySelector('.btn');
            
            // Disable button
            btn.disabled = true;
            btn.textContent = 'Signing in...';
            errorDiv.classList.remove('show');
            
            try {
                const res = await fetch(baseUrl + '/api/login', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({username, password})
                });
                
                const data = await res.json();
                
                if (res.ok && data.success) {
                    btn.textContent = 'Success! Redirecting...';
                    setTimeout(() => {
                        window.location.href = baseUrl + '/admin.php';
                    }, 500);
                } else {
                    errorDiv.textContent = data.error || 'Invalid credentials. Please try again.';
                    errorDiv.classList.add('show');
                    btn.disabled = false;
                    btn.textContent = 'Sign In';
                }
            } catch (e) {
                errorDiv.textContent = 'Connection error: ' + e.message;
                errorDiv.classList.add('show');
                btn.disabled = false;
                btn.textContent = 'Sign In';
            }
        });
    </script>
</body>
</html>
