<?php
/**
 * Configuration file for License Server
 */

// Database file path (in same directory as script)
define('DB_FILE', __DIR__ . '/licenses.db');

// Admin users file
define('ADMIN_USERS_FILE', __DIR__ . '/admin_users.json');

// Logs directory
define('LOGS_DIR', __DIR__ . '/logs');

// Create logs directory if it doesn't exist
if (!is_dir(LOGS_DIR)) {
    mkdir(LOGS_DIR, 0755, true);
}

// Log file
define('LOG_FILE', LOGS_DIR . '/license_server.log');

// Default admin credentials (change after first login!)
define('DEFAULT_ADMIN_USERNAME', 'admin');
define('DEFAULT_ADMIN_PASSWORD', 'ironcloud12@');

// Session settings
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 0); // Set to 1 if using HTTPS

// Timezone
date_default_timezone_set('UTC');

// Error reporting (disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 0); // Set to 0 in production
ini_set('log_errors', 1);
ini_set('error_log', LOG_FILE);
