<?php
/**
 * Authentication utilities
 */

require_once __DIR__ . '/config.php';

/**
 * Check if user is authenticated
 */
function is_authenticated() {
    return isset($_SESSION['authenticated']) && $_SESSION['authenticated'] === true;
}

/**
 * Authenticate user
 */
function authenticate($username, $password) {
    $users = load_admin_users();
    
    // Check default admin
    if ($username === DEFAULT_ADMIN_USERNAME && $password === DEFAULT_ADMIN_PASSWORD) {
        return true;
    }
    
    // Check stored users
    if (isset($users[$username])) {
        $stored_hash = $users[$username];
        if (password_verify($password, $stored_hash)) {
            return true;
        }
    }
    
    return false;
}

/**
 * Load admin users from file
 */
function load_admin_users() {
    if (!file_exists(ADMIN_USERS_FILE)) {
        return [];
    }
    
    $content = file_get_contents(ADMIN_USERS_FILE);
    $users = json_decode($content, true);
    
    return $users ?: [];
}

/**
 * Save admin users to file
 */
function save_admin_users($users) {
    $json = json_encode($users, JSON_PRETTY_PRINT);
    file_put_contents(ADMIN_USERS_FILE, $json);
}

/**
 * Create admin user
 */
function create_admin_user($username, $password) {
    $users = load_admin_users();
    $hash = password_hash($password, PASSWORD_DEFAULT);
    $users[$username] = $hash;
    save_admin_users($users);
}
