# Telegram Bot for License Management

PHP-based Telegram bot for managing licenses via Telegram.

## Features

- ✅ Add licenses
- ✅ List all licenses
- ✅ View license info
- ✅ Delete/deactivate licenses
- ✅ Button-based navigation
- ✅ Admin-only access

## Setup

### Step 1: Create Telegram Bot

1. Open Telegram and search for [@BotFather](https://t.me/BotFather)
2. Send `/newbot` command
3. Follow instructions to create your bot
4. Copy the bot token (looks like: `123456789:ABCdefGHIjklMNOpqrsTUVwxyz`)

### Step 2: Get Your Telegram User ID

1. Search for [@userinfobot](https://t.me/userinfobot) on Telegram
2. Start a chat with it
3. It will send you your user ID (a number like `123456789`)

### Step 3: Configure Bot

1. Copy `bot_config.json.example` to `bot_config.json`:
   ```bash
   cp bot_config.json.example bot_config.json
   ```

2. Edit `bot_config.json`:
   ```json
   {
     "bot_token": "YOUR_BOT_TOKEN_HERE",
     "admin_user_ids": [YOUR_TELEGRAM_USER_ID]
   }
   ```

3. Add multiple admins (optional):
   ```json
   {
     "bot_token": "YOUR_BOT_TOKEN",
     "admin_user_ids": [123456789, 987654321]
   }
   ```

### Step 4: Set Up Webhook (Recommended for cPanel)

**Option A: Using cPanel File Manager**

1. Upload `telegram_bot.php` to your license server directory
2. Get your webhook URL: `https://your-domain.com/license/telegram_bot.php`
3. Set webhook via browser:
   ```
   https://api.telegram.org/bot<YOUR_BOT_TOKEN>/setWebhook?url=https://your-domain.com/license/telegram_bot.php
   ```

**Option B: Using cURL**

```bash
curl -X POST "https://api.telegram.org/bot<YOUR_BOT_TOKEN>/setWebhook?url=https://your-domain.com/license/telegram_bot.php"
```

**Option C: Using Browser**

Visit this URL (replace with your bot token and domain):
```
https://api.telegram.org/botYOUR_BOT_TOKEN/setWebhook?url=https://your-domain.com/license/telegram_bot.php
```

### Step 5: Test Webhook

Visit this URL to check webhook status:
```
https://api.telegram.org/botYOUR_BOT_TOKEN/getWebhookInfo
```

Should show your webhook URL if set correctly.

## Usage

### Commands

- `/start` - Show main menu with buttons
- `/help` - Show help message
- `/add` - Add new license (shows type selection)
- `/list` - List all licenses
- `/info <license_id>` - Get detailed license information
- `/delete <license_id>` - Delete/deactivate license

### Button Navigation

The bot uses inline keyboard buttons for easy navigation:

1. **Main Menu** - Shows all available actions
2. **Add License** - Select license type
3. **List Licenses** - View all licenses
4. **License Info** - Get license details
5. **Delete License** - Deactivate license

## Example Usage

```
User: /start
Bot: Shows main menu with buttons

User: Clicks "📋 List Licenses"
Bot: Shows all licenses with status

User: /info 1
Bot: Shows detailed info for license #1

User: /delete 1
Bot: Deactivates license #1
```

## Security

- ✅ Only admin user IDs can use the bot
- ✅ All commands check admin status
- ✅ Bot token stored in `bot_config.json` (not in code)
- ✅ `bot_config.json` should be excluded from public access

## Troubleshooting

### Bot Not Responding

1. **Check webhook:**
   ```
   https://api.telegram.org/botYOUR_BOT_TOKEN/getWebhookInfo
   ```

2. **Check bot_config.json:**
   - Make sure file exists
   - Verify bot token is correct
   - Check admin user IDs are correct

3. **Check file permissions:**
   ```bash
   chmod 644 bot_config.json
   chmod 644 telegram_bot.php
   ```

4. **Check PHP error logs:**
   - Look in cPanel error logs
   - Check `logs/license_server.log`

### Webhook Not Working

1. **Verify webhook URL is accessible:**
   - Visit: `https://your-domain.com/license/telegram_bot.php`
   - Should show "Telegram Bot is running..." or nothing (not 404)

2. **Check SSL certificate:**
   - Telegram requires HTTPS
   - Make sure your domain has valid SSL

3. **Re-set webhook:**
   ```
   https://api.telegram.org/botYOUR_BOT_TOKEN/setWebhook?url=https://your-domain.com/license/telegram_bot.php
   ```

### Bot Says "Access Denied"

- Your Telegram user ID is not in `admin_user_ids` array
- Add your user ID to `bot_config.json`
- Get your user ID from [@userinfobot](https://t.me/userinfobot)

## File Structure

```
license_server/
├── telegram_bot.php       # Bot handler
├── bot_config.json        # Bot configuration (create from example)
├── bot_config.json.example # Template
└── README_TELEGRAM_BOT.md # This file
```

## Polling Mode (Testing)

For testing without webhook, you can run polling mode:

```bash
php telegram_bot.php
```

This will fetch updates manually. For production, use webhook mode.

## Integration with Web Panel

The bot uses the same database as the web panel:
- Same `licenses.db` database
- Same functions from `db.php` and `utils.php`
- Changes made via bot appear in web panel
- Changes made via web panel appear in bot

## Commands Reference

| Command | Description | Example |
|---------|-------------|---------|
| `/start` | Show main menu | `/start` |
| `/help` | Show help | `/help` |
| `/add` | Add license | `/add` |
| `/list` | List licenses | `/list` |
| `/info <id>` | License info | `/info 1` |
| `/delete <id>` | Delete license | `/delete 1` |

## Notes

- Bot requires PHP with cURL extension (usually enabled)
- Webhook requires HTTPS (SSL certificate)
- Bot token should be kept secret
- Admin user IDs are checked on every command
