# PHP License Server - cPanel Deployment

## ✅ Why PHP?

**PHP is the BEST choice for cPanel hosting because:**
- ✅ Works out of the box - no setup needed!
- ✅ No Python App feature required
- ✅ No pip installs needed
- ✅ Just upload files and it works
- ✅ SQLite built-in (no MySQL setup needed)
- ✅ All cPanel hosts support PHP

## 🚀 Quick Setup (5 Minutes!)

### Step 1: Upload Files

1. **Open cPanel File Manager**
2. **Navigate to:** `public_html` (or your domain root)
3. **Create folder:** `license` (or any name you want)
4. **Upload ALL files** from `license_server/` folder:
   - `index.php`
   - `config.php`
   - `db.php`
   - `auth.php`
   - `utils.php`
   - `login.php`
   - `admin.php`
   - `.htaccess`
   - `templates/` folder (if you have custom templates)

### Step 2: Set Permissions

**Via File Manager:**
- Right-click `license` folder → Change Permissions
- Set to: **755** (folders) and **644** (files)

**Or via SSH:**
```bash
cd ~/public_html/license
chmod 755 .
chmod 644 *.php
chmod 644 .htaccess
```

### Step 3: Test It!

1. **Visit:** `https://your-domain.com/license`
2. **Should see:** Login page
3. **Login with:**
   - Username: `admin`
   - Password: `admin123`

**That's it! No other setup needed!** 🎉

## 📁 File Structure

```
public_html/
└── license/
    ├── index.php          # Main router
    ├── config.php         # Configuration
    ├── db.php             # Database functions
    ├── auth.php           # Authentication
    ├── utils.php          # Utilities
    ├── login.php          # Login page
    ├── admin.php          # Admin dashboard
    ├── .htaccess          # Apache config
    ├── licenses.db        # SQLite database (auto-created)
    ├── admin_users.json   # Admin users (auto-created)
    └── logs/              # Logs directory (auto-created)
```

## 🔧 Configuration

**Edit `config.php` to customize:**

```php
// Default admin (change after first login!)
define('DEFAULT_ADMIN_USERNAME', 'admin');
define('DEFAULT_ADMIN_PASSWORD', 'admin123');

// Database location
define('DB_FILE', __DIR__ . '/licenses.db');

// Logs location
define('LOGS_DIR', __DIR__ . '/logs');
```

## 🔐 Security

**After first login:**
1. Change default admin password
2. Edit `admin_users.json` to add more admins
3. Or use the admin panel to manage users

## 📡 API Endpoints

**Same as Python version - fully compatible!**

### Public Endpoints:
- `POST /api/validate` - Validate license
- `GET /api/health` - Health check

### Admin Endpoints (Requires Login):
- `GET /api/licenses` - List all licenses
- `POST /api/licenses` - Create license
- `PUT /api/licenses/<id>` - Update license
- `DELETE /api/licenses/<id>` - Delete license
- `POST /api/login` - Login
- `POST /api/logout` - Logout

## 🎯 Advantages Over Python

| Feature | Python | PHP |
|---------|--------|-----|
| Setup Time | 30+ minutes | 5 minutes |
| Requires Python App | ✅ Yes | ❌ No |
| Requires pip install | ✅ Yes | ❌ No |
| Works on all cPanel | ❌ No | ✅ Yes |
| Easy to deploy | ❌ No | ✅ Yes |
| No configuration | ❌ No | ✅ Yes |

## 🐛 Troubleshooting

### Issue: 404 Error

**Solution:**
- Check `.htaccess` file exists
- Check file permissions (644 for files, 755 for folders)
- Check Apache mod_rewrite is enabled (usually is)

### Issue: Database Error

**Solution:**
- Check `licenses.db` file permissions (should be writable)
- Check disk space
- Check PHP SQLite extension is enabled (usually is)

### Issue: Login Not Working

**Solution:**
- Check default credentials: `admin` / `admin123`
- Check `admin_users.json` file permissions
- Check PHP session directory is writable

### Issue: API Returns 500 Error

**Solution:**
- Check `logs/license_server.log` for errors
- Check PHP error logs in cPanel
- Check file permissions

## 📝 Requirements

- ✅ PHP 7.0+ (most cPanel hosts have 7.4+)
- ✅ SQLite extension (usually enabled)
- ✅ Apache mod_rewrite (usually enabled)
- ✅ That's it!

## 🔄 Migration from Python

**If you had Python version:**
1. Your `licenses.db` database is compatible!
2. Just copy `licenses.db` to PHP version
3. All licenses will work immediately

## 📞 Support

**Common Issues:**
- **404 Error:** Check `.htaccess` and permissions
- **500 Error:** Check PHP error logs
- **Database Error:** Check file permissions
- **Login Issues:** Check default credentials

**All issues are usually permission-related!**

## 🎉 That's It!

PHP version is **much simpler** than Python:
- ✅ No setup needed
- ✅ Works immediately
- ✅ No dependencies
- ✅ Easy to maintain

Just upload and go! 🚀
