# PADRINO License Server - PHP Version

License management server for PADRINO 4.0 365 SENDER.

**✅ PHP Version - Works out of the box on all cPanel hosts!**

## 🚀 Quick Start (5 Minutes!)

1. **Upload files** to `public_html/license/` on cPanel
2. **Set permissions:** 755 (folders), 644 (files)
3. **Visit:** `https://your-domain.com/license`
4. **Login:** `admin` / `admin123`

**That's it! No configuration needed!** ✅

See **[README_PHP.md](README_PHP.md)** for complete setup guide.

## Features

- 🔐 Admin-only license management panel
- 🎫 License generation with hardware ID binding
- ✅ License validation API
- 🔒 Secure authentication
- 📊 License tracking and management
- 💾 SQLite database (no MySQL needed)

## API Endpoints

### Public Endpoints

- `POST /api/validate` - Validate license key
- `GET /api/health` - Health check

### Admin Endpoints (Requires Login)

- `GET /api/licenses` - List all licenses
- `POST /api/licenses` - Create new license
- `PUT /api/licenses/<id>` - Update license
- `DELETE /api/licenses/<id>` - Deactivate license
- `POST /api/login` - Login
- `POST /api/logout` - Logout

## File Structure

```
license_server/
├── index.php          # Main router and API handler
├── config.php         # Configuration
├── db.php             # Database functions (SQLite)
├── auth.php           # Authentication
├── utils.php          # Utilities
├── login.php          # Login page
├── admin.php          # Admin dashboard
├── .htaccess          # Apache configuration
├── licenses.db        # SQLite database (auto-created)
├── admin_users.json   # Admin users (auto-created)
└── logs/              # Logs directory (auto-created)
```

## Requirements

- ✅ PHP 7.0+ (most cPanel hosts have 7.4+)
- ✅ SQLite extension (usually enabled)
- ✅ Apache mod_rewrite (usually enabled)
- ✅ That's it!

## Configuration

Edit `config.php` to customize:

```php
// Default admin (change after first login!)
define('DEFAULT_ADMIN_USERNAME', 'admin');
define('DEFAULT_ADMIN_PASSWORD', 'admin123');

// Database location
define('DB_FILE', __DIR__ . '/licenses.db');

// Logs location
define('LOGS_DIR', __DIR__ . '/logs');
```

## Security

- ✅ Change default admin password after first login
- ✅ Use HTTPS in production
- ✅ Keep `admin_users.json` and `licenses.db` secure
- ✅ Don't expose sensitive files publicly

## Documentation

- **[README_PHP.md](README_PHP.md)** - Complete PHP setup and deployment guide
- Includes troubleshooting, API docs, and security notes

## Troubleshooting

### 404 Error
- Check `.htaccess` file exists
- Check file permissions (644 for files, 755 for folders)
- Check Apache mod_rewrite is enabled

### Database Error
- Check `licenses.db` file permissions (should be writable)
- Check disk space
- Check PHP SQLite extension is enabled

### Login Not Working
- Check default credentials: `admin` / `admin123`
- Check `admin_users.json` file permissions
- Check PHP session directory is writable

See [README_PHP.md](README_PHP.md) for detailed troubleshooting.

## License

Proprietary - All rights reserved
